Scriptname SKDP_OrthusSuicide extends ObjectReference  
{Orthus kills himself if Suvaris' Logbook is not retreived}

Actor Property Orthus Auto
Actor Property OrthusRinger Auto
Book Property _OrthusSuicideNote2SKDP Auto
Potion Property DamageHealth04 Auto
Quest Property MS10 Auto
Idle Property IdleDrinkPotion Auto
Bool Property Unread = True Auto

Event OnRead()
	If Unread ; We only want to do this once
		Float SuicideTime = Math.Floor(Utility.GetCurrentGameTime()) + 1.9 ; that is just after 9:30 pm, the next day
		Float HoursLeft = (SuicideTime - Utility.GetCurrentGameTime()) * 24
		; Float HoursLeft =1 ; for testing purposes.
		RegisterForSingleUpdateGameTime(HoursLeft)
		Unread = False
		; Debug.notification("Orthus will do it in " + HoursLeft + " Hours.")
		; Debug.notification("Orthus will do it in " + Math.Floor(HoursLeft*60) + " game minutes.")
	EndIf
EndEvent

Event OnUpdateGameTime() 
	If MS10.GetStageDone(20) == False ;  TRUE if the ledger is stolen and returned to Orthus, otherwise...
		Orthus.Disable()
		OrthusRinger.Enable()
		OrthusRinger.AddItem(DamageHealth04)
		OrthusRinger.EquipItem(DamageHealth04, true, true)
		Utility.Wait(2.0)
		OrthusRinger.PlayIdle(IdleDrinkPotion)
		Utility.Wait(6.0)
		ObjectReference KillSite = OrthusRinger.placeatme(DamageHealth04,1)
		KillSite.MoveTo(KillSite,0,0,60.0)
		KillSite.PlaceAtMe(_OrthusSuicideNote2SKDP,1) 
		OrthusRinger.Kill()
		OrthusRinger.RemoveItem(DamageHealth04)
	EndIf
EndEvent
